<?php
/**
*
* This file is part of the phpBB Forum Software package.
*
* @copyright (c) phpBB Limited <https://www.phpbb.com>, phpBBservice.nl <http://www.phpbbservice.nl>, phpBB.nl <http://www.phpbb.nl>
* @license GNU General Public License, version 2 (GPL-2.0)
*
* For full copyright and license information, please see
* the docs/CREDITS.txt file.
*
*/

/**
* DO NOT CHANGE
*/
if (!defined('IN_PHPBB'))
{
	exit;
}

if (empty($lang) || !is_array($lang))
{
	$lang = array();
}

// DEVELOPERS PLEASE NOTE
//
// All language files should use UTF-8 as their encoding and the files must not contain a BOM.
//
// Placeholders can now contain order information, e.g. instead of
// 'Page %s of %s' you can (and should) write 'Page %1$s of %2$s', this allows
// translators to re-order the output of data while ensuring it remains correct
//
// You do not need this where single placeholders are used, e.g. 'Message %d' is fine
// equally where a string contains only two placeholders which are used to wrap text
// in a url you again do not need to specify an order e.g., 'Click %sHERE%s' is fine

// Privacy policy and T&C
$lang = array_merge($lang, array(
	'TERMS_OF_USE_CONTENT'	=> 'Door het bezoeken van “%1$s” (hierna genoemd “wij”, “ons”, “onze”, “%1$s”, “%2$s”), ga je automatisch akkoord met de volgende voorwaarden. Als je niet akkoord gaat met deze voorwaarden, bezoek of gebruik “%1$s” dan niet langer. We hebben het recht om de voorwaarden op ieder moment te wijzigen en zullen ons best doen om je hiervan tijdig op de hoogte te brengen, het is echter aan te raden om zelf de voorwaarden regelmatig te controleren op wijzigingen. kan je niet akkoord gaan met deze wijzigingen, maak dan niet langer gebruik van “%1$s”. Blijft u gebruik maken van “%1$s”, dan ga je automatisch akkoord met de wijzigingen en of toevoegingen.<br />
	<br />
	Dit forum draait op phpBB. phpBB is een bulletinboard oplossing dat is uitgebracht onder de “<a href="http://opensource.org/licenses/gpl-2.0.php">GNU General Public License v2</a>” (hierna “GPL”) en kan gedownload worden via <a href="https://www.phpbb.com/">www.phpbb.com</a> en via de Nederlandstalige websites <a href="http://www.phpbbservice.nl">www.phpbbservice.nl</a> en <a href="http://www.phpbb.nl">www.phpbb.nl</a>. De phpBB software vergemakkelijkt alleen de internet gebaseerde discussies. phpBB Limited is niet verantwoordelijk voor de inhoud en/of de houding van wat er is toegestaan en wat niet. Meer informatie over phpBB, kan je vinden op de volgende websites <a href="https://www.phpbb.com/">https://www.phpbb.com/</a> of de Nederlandstalige websites <a href="http://www.phpbbservice.nl">www.phpbbservice.nl</a> en en <a href="http://www.phpbb.nl">www.phpbb.nl</a>.<br />
	<br />
	Je gaat akkoord met het volgende: geen kwetsende, obscene, vulgaire, lasterlijke, haatdragende, dreigende, seksueel georiënteerde of anderzijds verwerpelijke berichten te plaatsen, die de van toepassing zijnde regels en/of wetten schenden die gelden voor je land, het land waar “%1$s” is gehost of de internationale wetgeving. Het plaatsen van dergelijke berichten kan ertoe leiden dat je met onmiddellijke ingang en permanent wordt verbannen van dit forum. Tevens kan je serviceprovider worden ingelicht. De IP-adressen van alle berichten worden opgeslagen om deze voorwaarden te kunnen waarborgen. Je gaat er mee akkoord dat “%1$s” het recht heeft om ieder onderwerp te verwijderen, te wijzigen, te sluiten of te verplaatsen wanneer zij dit nodig achten. Als gebruiker ga je ermee akkoord dat de informatie die je bij ons invoert, wordt opgeslagen in een database. Hoewel deze informatie niet aan een derde partij zal worden verstrekt zonder je toestemming, kan “%1$s” noch phpBB niet verantwoordelijk worden gehouden voor een hackpoging die ertoe kan leiden dat de gegevens vrijkomen.
	',

	'PRIVACY_POLICY'		=> 'Dit beleid legt in detail uit hoe “%1$s” samen met zijn verbonden diensten en bedrijven (hierna “wij”, “ons”, “onze”, “%1$s”, “%2$s”) en phpBB (hierna “zij”, “hun”, “zijn”, “phpBB software”, “www.phpbb.com”, “phpBB Limited”, “phpBB-teams”) de informatie die wordt verzameld gedurende een bezoek aan dit forum, wordt gebruikt (hierna “je informatie”).<br />
	<br />
	Je informatie wordt op twee manieren verzameld. De eerste manier is door het gebruik van zogenaamde cookies. De phpBB software maakt meerdere cookies aan (kleine tekstbestanden die naar de tijdelijke internetbestanden van uw computer worden gedownload). De eerste twee cookies bevaten een indentificatienummer (hierna “user-id”) en een anonieme sessienummer (hierna “session-id”). Deze twee nummers worden automatisch door de phpBB software aan je toegewezen. Een derde cookie zal worden aangemaakt wanneer je onderwerpen hebt gelezen op “%1$s”. Dit cookie wordt gebruikt om op te slaan welke onderwerpen gelezen zijn, en verbeterd daarmee je gebruikerservaring.<br />
	<br />
	Wij kunnen ook cookies extern aanmaken aan de phpBB software wanneer je “%1$s” doorzoekt. Hoewel dit buiten dit document valt omdat dit geen betrekking heeft op de pagina’s die worden aangemaakt door de phpBB-software. De tweede manier is waarin wij je informatie verzamelen door wat je aan ons verstuurd. Dit kan zijn, en is niet beperkt naar: het plaatsen als een anonieme gebruiker (hierna “anonieme berichten”), registreren op “%1$s” (hierna “je account”) en berichten die verstuurd zijn na je registratie en wanneer je bent aangemeld (hierna “je berichten”).<br />
	<br />
	Je account bevat minstens een unieke identificeerbare naam (hierna “je gebruikersnaam”), een persoonlijk wachtwoord om te kunnen aanmelden op je account (hierna “je wachtwoord”) en een persoonlijk, geldig e-mailadres (hierna “je e-mail”). Je informatie voor je account op “%1$s” is beveiligd door de gegevensbeschermingswetgeving dat geldt in het land waar dit forum gehost wordt. Iedere informatie naast je gebruikersnaam, je wachtwoord en je e-mailadres dat vereist is gedurend het registratieproces op “%1$s” is niet vereist maar optioneel. Je hebt de optie welke informatie in je account openbaar kan worden weergegeven. Verder heb je ook de mogelijkheid, om in te stellen of je de e-mails die automatisch worden gemaakt door de phpBB-software wilt ontvangen.<br />
	<br />
	Je wachtwoord is versleuteld (en kan niet ontsleuteld gemaakt worden), waardoor het op een veilige manier is opgeslagen. Desondanks is het niet aan te raden dat je hetzelfde wachtwoord gebruikt op diverse websites. Je wachtwoord is het middel waarmee je op je account op “%1$s” kan aanmelden, bewaar het dus veilig en geef het op geen enkele manier aan %1$s”, phpBB of een andere derde partij. Als je het wachtwoord van je account bent vergeten, kan je de “Ik ben mijn wachtwoord vergeten” optie gebruiken die je terug kan vinden in het aanmeldvenster. Dit proces vereist dat je de gebruikersnaam en e-mailadres opgeeft van je gebruikersaccount, waarna de phpBB-software een nieuw wachtwoord zal genereren en opsturen naar het e-mailadres, zodat je opnieuw kan aanmelden.<br />
	',
));

// Common language entries
$lang = array_merge($lang, array(
	'ACCOUNT_ACTIVE'				=> 'Je account is nu geactiveerd. Dank je wel voor het registreren.',
	'ACCOUNT_ACTIVE_ADMIN'			=> 'Het account is nu geactiveerd.',
	'ACCOUNT_ACTIVE_PROFILE'		=> 'Je account is met succes geheractiveerd.',
	'ACCOUNT_ADDED'					=> 'Dank je wel voor het registreren, je account is aangemaakt. Je kan nu aanmelden met je gebruikersnaam en wachtwoord.',
	'ACCOUNT_COPPA'					=> 'Je account is aangemaakt, maar moet nog goedgekeurd worden, controleer je e-mail voor details.',
	'ACCOUNT_EMAIL_CHANGED'			=> 'Je account is bijgewerkt. Echter vereist dit forum account heractivatie bij e-mail veranderingen. Een activatiesleutel is verstuurd naar het nieuwe e-mailadres dat je hebt opgegeven. Controleer je e-mail voor meer informatie.',
	'ACCOUNT_EMAIL_CHANGED_ADMIN'	=> 'Je account is bijgewerkt. Echter vereist dit forum account heractivatie door een beheerder bij e-mail veranderingen. Een e-mail is verstuurt naar hun en je zal geïnformeerd worden wanneer je account is geheractiveerd.',
	'ACCOUNT_INACTIVE'				=> 'Je account is aangemaakt. Echter vereist dit forum account activatie, een activatiesleutel is verstuurd naar het e-mailadres dat je hebt opgegeven. Controleer je e-mail voor meer informatie.',
	'ACCOUNT_INACTIVE_ADMIN'		=> 'Je account is aangemaakt. Echter vereist dit forum account activatie door een beheerder. Een e-mail is verstuurd naar hun en je zal geïnformeerd worden wanneer je account is geactiveerd.',
	'ACTIVATION_EMAIL_SENT'			=> 'De activatie e-mail is verstuurd naar je e-mailadres.',
	'ACTIVATION_EMAIL_SENT_ADMIN'	=> 'De activatie e-mail is verstuurd naar de beheerders.',
	'ADD'							=> 'Toevoegen',
	'ADD_BCC'						=> '[BCC] toevoegen',
	'ADD_FOES'						=> 'Nieuwe vijanden toevoegen',
	'ADD_FOES_EXPLAIN'				=> 'Je kan verschillende gebruikersnamen toevoegen elk op een andere regel.',
	'ADD_FOLDER'					=> 'Map toevoegen',
	'ADD_FRIENDS'					=> 'Nieuwe vrienden toevoegen',
	'ADD_FRIENDS_EXPLAIN'			=> 'Je kan verschillende gebruikersnamen toevoegen elk op een andere regel.',
	'ADD_NEW_RULE'					=> 'Nieuwe regel toevoegen',
	'ADD_RULE'						=> 'Regel toevoegen',
	'ADD_TO'						=> '[Aan] toevoegen',
	'ADD_USERS_UCP_EXPLAIN'			=> 'Hier kan je nieuwe gebruikers toevoegen aan de groep. Je kan ook selecteren of deze groep de nieuwe standaard groep wordt voor de geselecteerde gebruikers. Vul ieder gebruikersnaam in op een aparte regel.',
	'ADMIN_EMAIL'					=> 'Beheerders kunnen mij informatie e-mailen',
	'AGREE'							=> 'Ik ga akkoord met deze voorwaarden',
	'ALLOW_PM'						=> 'Sta gebruikers toe om je privéberichten te versturen',
	'ALLOW_PM_EXPLAIN'				=> 'Let op dat beheerders en moderators altijd je een bericht kunnen sturen.',
	'ALREADY_ACTIVATED'				=> 'Je hebt je account al geactiveerd.',
	'ATTACHMENTS_EXPLAIN'			=> 'Dit is een lijst van bijlagen die je geplaatst hebt in berichten op dit forum.',
	'ATTACHMENTS_DELETED'			=> 'Bijlagen succesvol verwijderd.',
	'ATTACHMENT_DELETED'			=> 'Bijlage succesvol verwijderd.',
	'AUTOLOGIN_SESSION_KEYS_DELETED'=> 'De geselecteerde "Onthoud me"-aanmeldsleutels zijn succesvol verwijderd.',
	'AVATAR_CATEGORY'				=> 'Categorie',
	'AVATAR_DRIVER_GRAVATAR_TITLE'	=> 'Gravatar',
	'AVATAR_DRIVER_GRAVATAR_EXPLAIN'=> 'Gravatar is een service dat je toestaat om dezelfde avatar te gebruiken over meerdere websites. Bezoek <a href="http://www.gravatar.com/">Gravatar</a> voor meer informatie.',
	'AVATAR_DRIVER_LOCAL_TITLE'		=> 'Galerij avatar',
	'AVATAR_DRIVER_LOCAL_EXPLAIN'	=> 'Je kan je avatar kiezen uit de lokaal beschikbare set van avatars.',
	'AVATAR_DRIVER_REMOTE_TITLE'	=> 'Externe avatar',
	'AVATAR_DRIVER_REMOTE_EXPLAIN'	=> 'Koppeling naar avatar afbeeldingen van een andere website.',
	'AVATAR_DRIVER_UPLOAD_TITLE'	=> 'Upload avatar',
	'AVATAR_DRIVER_UPLOAD_EXPLAIN'	=> 'Upload je eigen avatar.',
	'AVATAR_EXPLAIN'				=> 'Maximum dimensies; breedte: %1$s, hoogte: %2$s, bestandsgrootte: %3$.2f KiB.',
	'AVATAR_FEATURES_DISABLED'		=> 'De avatar functionaliteit is momenteel uitgeschakeld.',
	'AVATAR_GALLERY'				=> 'Lokale galerij',
	'AVATAR_GENERAL_UPLOAD_ERROR'	=> 'Kan avatar niet uploaden naar %s.',
	'AVATAR_NOT_ALLOWED'			=> 'Je avatar kan niet weergegeven worden omdat avatars niet toegestaan zijn.',
	'AVATAR_PAGE'					=> 'Pagina',
	'AVATAR_SELECT'					=> 'Selecteer je avatar',
	'AVATAR_TYPE'					=> 'Avatar type',
	'AVATAR_TYPE_NOT_ALLOWED'		=> 'Je bestaande avatar kan niet weergegeven worden omdat dit type niet is toegestaan.',

	'BACK_TO_DRAFTS'			=> 'Terug naar opgeslagen concepten',
	'BACK_TO_LOGIN'				=> 'Terug naar aanmeldvenster',
	'BIRTHDAY'					=> 'Verjaardag',
	'BIRTHDAY_EXPLAIN'			=> 'Het instellen van een jaartal zal je leeftijd weergeven wanneer het je verjaardag is.',
	'BOARD_DATE_FORMAT'			=> 'Mijn datumformaat',
	'BOARD_DATE_FORMAT_EXPLAIN'	=> 'De syntax die gebruikt wordt is identiek aan de PHP <a href="http://www.php.net/date">date()</a>-functie.',
	'BOARD_LANGUAGE'			=> 'Mijn taal',
	'BOARD_STYLE'				=> 'Mijn forumstijl',
	'BOARD_TIMEZONE'			=> 'Mijn tijdzone',
	'BOOKMARKS'					=> 'Favorieten',
	'BOOKMARKS_EXPLAIN'			=> 'Je kan onderwerpen markeren als favoriet voor toekomstige referentie. Selecteer het vakje voor elke favoriet die je wenst te verwijderen, en druk daarna op de <em>Verwijder gemarkeerde favorieten</em> knop.',
	'BOOKMARKS_DISABLED'		=> 'Favorieten zijn uitgeschakeld op dit forum.',
	'BOOKMARKS_REMOVED'			=> 'Favorieten succesvol verwijderd.',

	'CANNOT_EDIT_MESSAGE_TIME'	=> 'Je kan het bericht niet meer wijzigen of verwijderen.',
	'CANNOT_MOVE_TO_SAME_FOLDER'=> 'Berichten kunnen niet verplaatst worden naar de map die je wilt verwijderen.',
	'CANNOT_MOVE_FROM_SPECIAL'	=> 'Berichten kunnen niet verplaatst worden naar de uitbox.',
	'CANNOT_RENAME_FOLDER'		=> 'Deze map kan niet hernoemd worden.',
	'CANNOT_REMOVE_FOLDER'		=> 'Deze map kan niet verwijderd worden.',
	'CHANGE_DEFAULT_GROUP'		=> 'Verander standaard groep',
	'CHANGE_PASSWORD'			=> 'Verander wachtwoord',
	'CLICK_GOTO_FOLDER'			=> '%1$sGa naar je “%3$s” map%2$s',
	'CLICK_RETURN_FOLDER'		=> '%1$sTerug naar je “%3$s” map%2$s',
	'CONFIRMATION'				=> 'Bevestiging van registratie',
	'CONFIRM_CHANGES'			=> 'Bevestig veranderingen',
	'CONFIRM_EXPLAIN'			=> 'Om automatische registraties te voorkomen vereist dit forum dat je een bevestigingscode invoert. De code wordt weergegeven in de afbeelding die je hieronder kan zien. Als je visueel gehandicapt bent en deze code niet kan lezen, neem dan contact op met de %sForumbeheerder%s.',
	'VC_REFRESH'				=> 'Ververs bevestigingscode',
	'VC_REFRESH_EXPLAIN'		=> 'Als je de code niet kan lezen, kan je een nieuwe opvragen door op de knop te drukken.',

	'CONFIRM_PASSWORD'			=> 'Bevestig wachtwoord',
	'CONFIRM_PASSWORD_EXPLAIN'	=> 'Je hoeft alleen je wachtwoord te bevestigen als je deze hierboven hebt veranderd.',
	'COPPA_BIRTHDAY'			=> 'Om door te gaan met de registratieprocedure, vertel ons waar je bent geboren.',
	'COPPA_COMPLIANCE'			=> 'COPPA toestemming',
	'COPPA_EXPLAIN'				=> 'Let op dat met het klikken op verstuur je account aangemaakt wordt. Echter kan deze niet geactiveerd worden totdat een ouder of voogd je registratie goedkeurt. Je zal een kopie van de benodigde formulieren toegestuurd krijgen via de e-mail met daarin de details waarnaar toe dit verstuurd kan worden.',
	'CREATE_FOLDER'				=> 'Map toevoegen…',
	'CURRENT_IMAGE'				=> 'Bestaande afbeelding',
	'CURRENT_PASSWORD'			=> 'Bestaande wachtwoord',
	'CURRENT_PASSWORD_EXPLAIN'	=> 'Je moet je bestaande wachtwoord invoeren als je je e-mailadres of gebruikersnaam wilt wijzigen.',
	'CURRENT_CHANGE_PASSWORD_EXPLAIN' => 'Om je wachtwoord, je e-mailadres of je gebruikersnaam te wijzigen moet je je bestaande wachtwoord invoeren.',
	'CUR_PASSWORD_EMPTY'		=> 'Je hebt niet je bestaande wachtwoord ingevoerd.',
	'CUR_PASSWORD_ERROR'		=> 'Het bestaande wachtwoord dat je hebt ingevoerd is incorrect.',
	'CUSTOM_DATEFORMAT'			=> 'Eigen…',

	'DEFAULT_ACTION'			=> 'Standaard actie',
	'DEFAULT_ACTION_EXPLAIN'	=> 'Deze actie zal worden aangesproken als geen van bovenstaande toepasbaar is.',
	'DEFAULT_ADD_SIG'			=> 'Mijn onderschrift standaard bijvoegen',
	'DEFAULT_BBCODE'			=> 'BBCode standaard inschakelen',
	'DEFAULT_NOTIFY'			=> 'Notificeer me standaard bij reacties',
	'DEFAULT_SMILIES'			=> 'Smilies standaard inschakelen',
	'DEFINED_RULES'				=> 'Gedefinieerde regels',
	'DELETED_TOPIC'				=> 'Onderwerp is verwijderd.',
	'DELETE_ATTACHMENT'			=> 'Verwijder bijlage',
	'DELETE_ATTACHMENTS'		=> 'Verwijder bijlagen',
	'DELETE_ATTACHMENT_CONFIRM'	=> 'Weet je zeker dat je deze bijlage wilt verwijderen?',
	'DELETE_ATTACHMENTS_CONFIRM'=> 'Weet je zeker dat je deze bijlagen wilt verwijderen?',
	'DELETE_AVATAR'				=> 'Verwijder afbeelding',
	'DELETE_COOKIES_CONFIRM'	=> 'Weet je zeker dat je alle cookies ingesteld door dit forum wilt verwijderen?',
	'DELETE_MARKED_PM'			=> 'Verwijder gemarkeerde berichten',
	'DELETE_MARKED_PM_CONFIRM'	=> 'Weet je zeker dat je alle gemarkeerde berichten wilt verwijderen?',
	'DELETE_OLDEST_MESSAGES'	=> 'Verwijder oudste berichten',
	'DELETE_MESSAGE'			=> 'Verwijder berichten',
	'DELETE_MESSAGE_CONFIRM'	=> 'Weet je zeker dat je dit privébericht wilt verwijderen?',
	'DELETE_MESSAGES_IN_FOLDER'	=> 'Verwijder alle berichten in de verwijderde map',
	'DELETE_RULE'				=> 'Verwijder regel',
	'DELETE_RULE_CONFIRM'		=> 'Weet je zeker dat je deze regel wilt verwijderen?',
	'DEMOTE_SELECTED'			=> 'Degradeer geselecteerde',
	'DISABLE_CENSORS'			=> 'Woordcensuur inschakelen',
	'DISPLAY_GALLERY'			=> 'Galerij weergeven',
	'DOMAIN_NO_MX_RECORD_EMAIL'	=> 'Het ingevoerde e-maildomein heeft geen geldig MX record.',
	'DOWNLOADS'					=> 'Downloads',
	'DRAFTS_DELETED'			=> 'Alle geselecteerde concepten zijn succesvol verwijderd.',
	'DRAFTS_EXPLAIN'			=> 'Hier kan je je opgeslagen concepten bekijken, wijzigen en verwijderen.',
	'DRAFT_UPDATED'				=> 'Concept succesvol bijgewerkt.',

	'EDIT_DRAFT_EXPLAIN'		=> 'Hier kan je je concept wijzigen. Concepten bevatten geen bijlage- en peilingsinformatie.',
	'EMAIL_BANNED_EMAIL'		=> 'Het e-mailadres dat je hebt ingevoerd is niet toegestaan om te gebruiken.',
	'EMAIL_REMIND'				=> 'Dit moet het e-mailadres zijn dat geassocieerd wordt met je account. Als je dit niet veranderd hebt via je gebruikerspaneel dan is dit het e-mailadres waarmee je je geregistreerd hebt op dit forum.',
	'EMAIL_TAKEN_EMAIL'			=> 'Het ingevoerde e-mailadres is al in gebruik.',
	'EMPTY_DRAFT'				=> 'Je moet een bericht invoeren om je veranderingen te versturen.',
	'EMPTY_DRAFT_TITLE'			=> 'Je moet een concepttitel invoeren.',
	'EXPORT_AS_XML'				=> 'Exporteer als XML',
	'EXPORT_AS_CSV'				=> 'Exporteer als CSV',
	'EXPORT_AS_CSV_EXCEL'		=> 'Exporteer als CSV (Excel)',
	'EXPORT_AS_TXT'				=> 'Exporteer als TXT',
	'EXPORT_AS_MSG'				=> 'Exporteer als MSG',
	'EXPORT_FOLDER'				=> 'Exporteer deze weergave',

	'FIELD_REQUIRED'					=> 'Het veld “%s” moet ingevuld zijn.',
	'FIELD_TOO_SHORT'					=> array(
		1	=> 'Het veld “%2$s” is te kort, een minimum van %1$d teken is vereist.',
		2	=> 'Het veld “%2$s” is te kort, een minimum van %1$d tekens is vereist.',
	),
	'FIELD_TOO_LONG'					=> array(
		1	=> 'Het veld “%2$s” is te lang, een maximum van %1$d teken is toegestaan.',
		2	=> 'Het veld “%2$s” is te lang, een maximum van %1$d tekens is toegestaan.',
	),
	'FIELD_TOO_SMALL'					=> 'De waarde van “%2$s” is te klein, een minimum waarde van %1$d is vereist.',
	'FIELD_TOO_LARGE'					=> 'De waarde van “%2$s” is te lang, een maximum waarde van %1$d is toegestaan.',
	'FIELD_INVALID_CHARS_INVALID'		=> 'Het veld “%s” heeft ongeldige tekens.',
	'FIELD_INVALID_CHARS_NUMBERS_ONLY'	=> 'Het veld “%s” heeft ongeldige tekens, alleen cijfers zijn toegestaan.',
	'FIELD_INVALID_CHARS_ALPHA_DOTS'    => 'Het veld “%s” heeft ongeldige tekens, alleen alfanumerieke of . tekens zijn toegestaan.',
	'FIELD_INVALID_CHARS_ALPHA_ONLY'	=> 'Het veld “%s” heeft ongeldige tekens, alleen alfanumerieke tekens zijn toegestaan.',
	'FIELD_INVALID_CHARS_ALPHA_PUNCTUATION' => 'Het veld “%s” heeft ongeldige tekens, alleen alfanumerieke of _,-. tekens zijn toegestaan en het eerste teken moet alfabetisch zijn.',	
	'FIELD_INVALID_CHARS_ALPHA_SPACERS'	=> 'Het veld “%s” heeft ongeldige tekens, alleen alfanumerieke, spatie of -+_[] tekens zijn toegestaan.',
	'FIELD_INVALID_CHARS_ALPHA_UNDERSCORE'	=> 'Het veld “%s” heeft ongeldige tekens, alleen alfanumerieke of _ tekens zijn toegestaan.',
	'FIELD_INVALID_CHARS_LETTER_NUM_DOTS'	=> 'Het veld “%s” heeft ongeldige tekens, alleen letters, cijfers of . tekens zijn toegestaan.',
	'FIELD_INVALID_CHARS_LETTER_NUM_ONLY'	=> 'Het veld “%s” heeft ongeldige tekens, alleen letters en cijfers zijn toegestaan.',
	'FIELD_INVALID_CHARS_LETTER_NUM_PUNCTUATION'	=> 'Het veld “%s” heeft ongeldige tekens, alleen letters, cijfers of _,-. tekens zijn toegestaan en het eerste teken moet alfabetisch zijn.',
	'FIELD_INVALID_CHARS_LETTER_NUM_SPACERS'		=> 'Het veld “%s” heeft ongeldige tekens, alleen letters, cijfers, spaties of -+_[] tekens zijn toegestaan.',
	'FIELD_INVALID_CHARS_LETTER_NUM_UNDERSCORE'		=> 'Het veld “%s” heeft ongeldige tekens, alleen letters, cijfers of _ tekens zijn toegestaan.',
	'FIELD_INVALID_DATE'				=> 'Het veld “%s” heeft een ongeldige datum.',
    'FIELD_INVALID_URL'					=> 'Het veld “%s” heeft een ongeldige url.',
	'FIELD_INVALID_VALUE'				=> 'Het veld “%s” heeft een ongeldige waarde.',

	'FOE_MESSAGE'				=> 'Bericht van vijand',
	'FOES_EXPLAIN'				=> 'Vijanden zijn gebruikers die standaard genegeerd zullen worden. Berichten door deze gebruikers zullen niet volledig zichtbaar zijn. Privéberichten van vijanden zijn nog steeds toegestaan. Let op; je kan geen moderators of beheerders negeren.',
	'FOES_UPDATED'				=> 'Je vijandenlijst is succesvol bijgewerkt.',
	'FOLDER_ADDED'				=> 'Map succesvol toegevoegd.',
	'FOLDER_MESSAGE_STATUS'		=> array(
		1	=> '%2$d van %1$s bericht opgeslagen',
		2	=> '%2$d van %1$s berichten opgeslagen',
	),
	'FOLDER_NAME_EMPTY'			=> 'Je moet een naam invoeren voor deze map.',
	'FOLDER_NAME_EXIST'			=> 'Map <strong>%s</strong> bestaat al.',
	'FOLDER_OPTIONS'			=> 'Mapopties',
	'FOLDER_RENAMED'			=> 'Map succesvol hernoemd.',
	'FOLDER_REMOVED'			=> 'Map succesvol verwijderd.',
	'FOLDER_STATUS_MSG'			=> array(
		1	=> '%2$d van de %1$s opgeslagen',
		2	=> '%2$d van de %1$s opgeslagen',
	),
	'FORWARD_PM'				=> 'PB doorsturen',
	'FORCE_PASSWORD_EXPLAIN'	=> 'Voordat je door kan gaan met het bezoeken van het forum, moet je eerst je wachtwoord veranderen.',
	'FRIEND_MESSAGE'			=> 'Bericht van vriend',
	'FRIENDS'					=> 'Vrienden',
	'FRIENDS_EXPLAIN'			=> 'Vrienden maken het mogelijk om je snel toegang te verlenen aan gebruikers waarmee je regelmatig mee communiceert. Als de sjabloon de benodigde ondersteuning bied, kunnen elk bericht dat is gemaakt door een vriend uitgelicht zijn.',
	'FRIENDS_OFFLINE'			=> 'Offline',
	'FRIENDS_ONLINE'			=> 'Online',
	'FRIENDS_UPDATED'			=> 'Je vriendenlijst is succesvol bijgewerkt.',
	'FULL_FOLDER_OPTION_CHANGED'=> 'De actie om uit te voeren wanneer een map vol is, is succesvol veranderd.',
	'FWD_ORIGINAL_MESSAGE'		=> '-------- Origineel Bericht --------',
	'FWD_SUBJECT'				=> 'Onderwerp: %s',
	'FWD_DATE'					=> 'Datum: %s',
	'FWD_FROM'					=> 'Van: %s',
	'FWD_TO'					=> 'Aan: %s',

	'GLOBAL_ANNOUNCEMENT'		=> 'Algemene aankondiging',

	'GRAVATAR_AVATAR_EMAIL'			=> 'Gravatar e-mail',
	'GRAVATAR_AVATAR_EMAIL_EXPLAIN'	=> 'Voer het e-mailadres in die je hebt gebruikt voor het registreren van je account op <a href="http://www.gravatar.com/">Gravatar</a>.',
	'GRAVATAR_AVATAR_SIZE'			=> 'Avatar dimensies',
	'GRAVATAR_AVATAR_SIZE_EXPLAIN'	=> 'Specificeer de breedte en de hoogte van de avatar, laat leeg om automatische verificatie te proberen.',

	'HIDE_ONLINE'				=> 'Verberg mijn online status',
	'HIDE_ONLINE_EXPLAIN'		=> 'Het veranderen van deze instelling zal pas effectief worden na je volgend bezoek aan het forum.',
	'HOLD_NEW_MESSAGES'			=> 'Accepteer geen nieuwe berichten (Nieuwe berichten zullen vastgehouden worden totdat er genoeg ruimte beschikbaar is)',
	'HOLD_NEW_MESSAGES_SHORT'	=> 'Nieuwe berichten zullen vastgehouden worden',

	'IF_FOLDER_FULL'			=> 'Als de map vol is',
	'IMPORTANT_NEWS'			=> 'Belangrijke mededelingen',
	'INVALID_USER_BIRTHDAY'		=> 'De ingevoerde verjaardag is geen geldige datum.',
	'INVALID_CHARS_USERNAME'	=> 'De gebruikersnaam bevat verboden karakters.',
	'INVALID_CHARS_NEW_PASSWORD'=> 'Het wachtwoord bevat niet de vereiste karakters.',
	'ITEMS_REQUIRED'			=> 'De items gemarkeerd met * zijn vereiste profielvelden en moeten ingevuld worden.',

	'JOIN_SELECTED'				=> 'Lid worden van geselecteerde',

	'LANGUAGE'					=> 'Taal',
	'LINK_REMOTE_AVATAR'		=> 'Koppeling off-site',
	'LINK_REMOTE_AVATAR_EXPLAIN'=> 'Vul de URL van de locatie in die de avatar afbeelding bevat die je wenst te koppelen.',
	'LINK_REMOTE_SIZE'			=> 'Avatar dimensies',
	'LINK_REMOTE_SIZE_EXPLAIN'	=> 'Specificeer de breedte en hoogte van de avatar, laat leeg om automatische verificatie te proberen.',
	'LOGIN_EXPLAIN_UCP'			=> 'Meld je aan om toegang te krijgen tot het gebruikerspaneel.',
	'LOGIN_LINK'					=> 'Koppel of registreer je account op een externe service met je forumaccount',
	'LOGIN_LINK_EXPLAIN'			=> 'Je hebt geprobeerd om je aan te melden met een externe service die nog niet is verbonden met een account op dit forum. Je moet of dit account koppelen aan een bestaande account of een nieuw account aanmaken.',
	'LOGIN_LINK_MISSING_DATA'		=> 'Data dat vereist is om je account te koppelen met een externe service is niet beschikbaar. Herstart het aanmeldproces.',
	'LOGIN_LINK_NO_DATA_PROVIDED'	=> 'Geen data is gegeven op deze pagina om een extern account te koppelen aan een forumaccount. Neem contact op met de forumbeheerder als je problemen blijft ondervinden.',
	'LOGIN_KEY'					=> 'Aanmeldsleutel',
	'LOGIN_TIME'				=> 'Aanmeldtijd',
	'LOGIN_REDIRECT'			=> 'Je bent succesvol aangemeld.',
	'LOGOUT_FAILED'				=> 'Je bent niet afgemeld, omdat de aanvraag niet overeenkomt met je sessie. Neem contact op met de forumbeheerder als je problemen blijft ondervinden.',
	'LOGOUT_REDIRECT'			=> 'Je bent succesvol afgemeld.',

	'MARK_IMPORTANT'				=> 'Markeer/Demarkeer als belangrijk',
	'MARKED_MESSAGE'				=> 'Gemarkeerd bericht',
	'MAX_FOLDER_REACHED'			=> 'Maximum aantal toegestane gebruikers gedefinieerde mappen bereikt.',
	'MESSAGE_BY_AUTHOR'				=> 'door',
	'MESSAGE_COLOURS'				=> 'Bericht kleuren',
	'MESSAGE_DELETED'				=> 'Bericht succesvol verwijderd.',
	'MESSAGE_EDITED'				=> 'Bericht succesvol gewijzigd.',
	'MESSAGE_HISTORY'				=> 'Berichtengeschiedenis',
	'MESSAGE_REMOVED_FROM_OUTBOX'	=> 'Dit bericht is verwijderd door zijn auteur.',
	'MESSAGE_SENT_ON'				=> 'op',
	'MESSAGE_STORED'				=> 'Dit bericht is succesvol verstuurd.',
	'MESSAGE_TO'					=> 'Aan',
	'MESSAGES_DELETED'				=> 'Berichten succesvol verwijderd',
	'MOVE_DELETED_MESSAGES_TO'		=> 'Verplaats berichten van verwijderde map naar',
	'MOVE_DOWN'						=> 'Verplaats omlaag',
	'MOVE_MARKED_TO_FOLDER'			=> 'Verplaats gemarkeerde naar %s',
	'MOVE_PM_ERROR'					=> array(
		1	=> 'Een fout is opgetreden tijdens het verplaatsen van het bericht naar de nieuwe map, alleen %2$d van de %1$s berichten zijn verplaatst.',
		2	=> 'Een fout is opgetreden tijdens het verplaatsen van de berichten naar de nieuwe map, alleen %2$d van de %1$s berichten zijn verplaatst.',
	),
	'MOVE_TO_FOLDER'				=> 'Verplaats naar map',
	'MOVE_UP'						=> 'Verplaats omhoog',

	'NEW_FOLDER_NAME'				=> 'Nieuwe mapnaam',
	'NEW_PASSWORD'					=> 'Nieuw wachtwoord',
	'NEW_PASSWORD_CONFIRM_EMPTY'	=> 'Je hebt geen bevestigingswachtwoord ingevoerd.',
	'NEW_PASSWORD_ERROR'			=> 'De wachtwoorden die je hebt ingevoerd komen niet overeen.',

	'NOTIFICATIONS_MARK_ALL_READ'						=> 'Markeer alle notificaties gelezen',
	'NOTIFICATIONS_MARK_ALL_READ_CONFIRM'				=> 'Weet je zeker dat je alle notificaties als gelezen wilt markeren?',
	'NOTIFICATIONS_MARK_ALL_READ_SUCCESS'				=> 'Alle notificaties zijn gemarkeerd als gelezen.',
	'NOTIFICATION_GROUP_MISCELLANEOUS'					=> 'Diverse Notificaties',
	'NOTIFICATION_GROUP_MODERATION'						=> 'Moderatie Notificatie',
	'NOTIFICATION_GROUP_ADMINISTRATION'					=> 'Beheerders Notificatie',
	'NOTIFICATION_GROUP_POSTING'						=> 'Plaatsings Notificatie',
	'NOTIFICATION_METHOD_EMAIL'							=> 'E-mail',
	'NOTIFICATION_METHOD_JABBER'						=> 'Jabber',
	'NOTIFICATION_TYPE'									=> 'Notificatie type',
	'NOTIFICATION_TYPE_BOOKMARK'						=> 'Iemand heeft gereageerd op een onderwerp die je hebt gemarkeerd als favoriet',
	'NOTIFICATION_TYPE_GROUP_REQUEST'					=> 'Iemand heeft lidmaatschap aangevraagd voor een groep die je leid',
	'NOTIFICATION_TYPE_IN_MODERATION_QUEUE'				=> 'Een bericht of onderwerp heeft goedkeuring nodig',
	'NOTIFICATION_TYPE_MODERATION_QUEUE'				=> 'Je onderwerpen/berichten zijn goedgekeurd door een moderator',
	'NOTIFICATION_TYPE_PM'								=> 'Iemand heeft een privébericht verzonden naar je',
	'NOTIFICATION_TYPE_POST'							=> 'Iemand heeft gereageerd op een onderwerp waarop je bent geabonneerd',
	'NOTIFICATION_TYPE_QUOTE'							=> 'Iemand heeft je geciteerd in een bericht',
	'NOTIFICATION_TYPE_REPORT'							=> 'Iemand heeft een bericht gemeld',
	'NOTIFICATION_TYPE_TOPIC'							=> 'Iemand heeft een onderwerp aangemaakt in een forum waarop je bent geabonneerd',
	'NOTIFICATION_TYPE_ADMIN_ACTIVATE_USER'				=> 'Nieuw geregistreerde gebruiker vereist activatie',

	'NOTIFY_METHOD'					=> 'Notificatie methode',
	'NOTIFY_METHOD_BOTH'			=> 'Beide',
	'NOTIFY_METHOD_EMAIL'			=> 'Alleen e-mail',
	'NOTIFY_METHOD_EXPLAIN'			=> 'Methode voor het versturen van berichten via dit forum.',
	'NOTIFY_METHOD_IM'				=> 'Alleen Jabber',
	'NOTIFY_ON_PM'					=> 'Informeer me bij nieuwe privéberichten',
	'NOT_ADDED_FRIENDS_ANONYMOUS'	=> 'Je kan de anonieme gebruiker niet toevoegen aan je vriendenlijst.',
	'NOT_ADDED_FRIENDS_BOTS'		=> 'Je kan bots niet toevoegen aan je vriendenlijst.',
	'NOT_ADDED_FRIENDS_FOES'		=> 'Je kan geen gebruikers toevoegen aan je vriendenlijst die op je vijandenlijst staan.',
	'NOT_ADDED_FRIENDS_SELF'		=> 'Je kan jezelf niet toevoegen aan je vriendenlijst.',
	'NOT_ADDED_FOES_MOD_ADMIN'		=> 'Je kan beheerders en moderators niet toevoegen aan je vijandenlijst.',
	'NOT_ADDED_FOES_ANONYMOUS'		=> 'Je kan de anonieme gebruiker niet toevoegen aan je vijandenlijst.',
	'NOT_ADDED_FOES_BOTS'			=> 'Je kan bots niet toevoegen aan je vijandenlijst.',
	'NOT_ADDED_FOES_FRIENDS'		=> 'Je kan geen gebruikers toevoegen aan je vijandenlijst die op je vriendenlijst staan.',
	'NOT_ADDED_FOES_SELF'			=> 'Je kan jezelf niet toevoegen aan je vijandenlijst.',
	'NOT_AGREE'						=> 'Ik ga niet akkoord met deze voorwaarden',
	'NOT_ENOUGH_SPACE_FOLDER'		=> 'De doelmap “%s” lijkt vol te zijn. De gevraagde actie is niet uitgevoerd.',
	'NOT_MOVED_MESSAGES'			=> array(
		1	=> 'Je hebt momenteel %d privébericht dat teruggehouden wordt vanwege een volle map.',
		2	=> 'Je hebt momenteel %d privéberichten die teruggehouden worden vanwege een volle map.',
	),
	'NO_ACTION_MODE'				=> 'Geen berichten actie opgegeven.',
	'NO_AUTHOR'						=> 'Geen auteur geselecteerd voor dit bericht',
	'NO_AVATAR'						=> 'Geen avatar geselecteerd',
	'NO_AVATAR_CATEGORY'			=> 'Geen',

	'NO_AUTH_DELETE_MESSAGE'		=> 'Je mag geen privéberichten verwijderen.',
	'NO_AUTH_EDIT_MESSAGE'			=> 'Je mag geen privéberichten wijzigen.',
	'NO_AUTH_FORWARD_MESSAGE'		=> 'Je mag geen privéberichten doorsturen.',
	'NO_AUTH_GROUP_MESSAGE'			=> 'Je mag geen privéberichten sturen naar groepen.',
	'NO_AUTH_PASSWORD_REMINDER'		=> 'Je mag geen nieuw wachtwoord aanvragen.',
	'NO_AUTH_PROFILEINFO'			=> 'Je mag je profiel informatie niet wijzigen.',
	'NO_AUTH_READ_HOLD_MESSAGE'		=> 'Je mag geen privéberichten lezen die teruggehouden worden.',
	'NO_AUTH_READ_MESSAGE'			=> 'Je mag geen privéberichten lezen.',
	'NO_AUTH_READ_REMOVED_MESSAGE'	=> 'Je kan dit bericht niet lezen omdat deze is verwijderd door de auteur.',
	'NO_AUTH_SEND_MESSAGE'			=> 'Je mag geen privéberichten versturen.',
	'NO_AUTH_SIGNATURE'				=> 'Je mag geen onderschrift definiëren.',

	'NO_BCC_RECIPIENT'			=> 'Geen',
	'NO_BOOKMARKS'				=> 'Je hebt geen favorieten.',
	'NO_BOOKMARKS_SELECTED'		=> 'Je hebt geen favorieten geselecteerd.',
	'NO_EDIT_READ_MESSAGE'		=> 'Het privébericht kan niet gewijzigd worden omdat het al gelezen is.',
	'NO_EMAIL_USER'				=> 'Het opgegeven e-mailadres/gebruikersnaam informatie kan niet gevonden worden.',
	'NO_FOES'					=> 'Geen vijanden momenteel opgegeven',
	'NO_FRIENDS'				=> 'Geen vrienden momenteel opgegeven',
	'NO_FRIENDS_OFFLINE'		=> 'Geen vrienden offline',
	'NO_FRIENDS_ONLINE'			=> 'Geen vrienden online',
	'NO_GROUP_SELECTED'			=> 'Geen groep gespecificeerd.',
	'NO_IMPORTANT_NEWS'			=> 'Er zijn geen belangrijke mededelingen.',
	'NO_MESSAGE'				=> 'Privébericht kan niet worden gevonden.',
	'NO_NEW_FOLDER_NAME'		=> 'Je moet een nieuwe mapnaam opgeven.',
	'NO_NEWER_PM'				=> 'Geen nieuwere berichten.',
	'NO_OLDER_PM'				=> 'Geen oudere berichten.',
	'NO_PASSWORD_SUPPLIED'		=> 'Je kan niet aanmelden zonder wachtwoord.',
	'NO_RECIPIENT'				=> 'Geen ontvanger opgegeven.',
	'NO_RULES_DEFINED'			=> 'Geen regels opgegeven.',
	'NO_SAVED_DRAFTS'			=> 'Geen concepten opgeslagen.',
	'NO_TO_RECIPIENT'			=> 'Geen',
	'NO_WATCHED_FORUMS'			=> 'Je bent niet geabonneerd op een forum.',
	'NO_WATCHED_SELECTED'		=> 'Je hebt geen geabonneerde onderwerpen of forums geselecteerd.',
	'NO_WATCHED_TOPICS'			=> 'Je bent niet geabonneerd op een onderwerp.',

	'PASS_TYPE_ALPHA_EXPLAIN'	=> 'Wachtwoord moet tussen %1$s en %2$s tekens lang zijn en moet gewone letters, hoofdletters en nummers bevatten.',
	'PASS_TYPE_ANY_EXPLAIN'		=> 'Moet tussen %1$s en %2$s zijn.',
	'PASS_TYPE_CASE_EXPLAIN'	=> 'Wachtwoord moet tussen de %1$s en %2$s tekens lang zijn en moet gewone en hoofdletters bevatten.',
	'PASS_TYPE_SYMBOL_EXPLAIN'	=> 'Wachtwoord moet tussen de %1$s en %2$s tekens lang zijn en moet gewone letters, hoofdletters, nummers en symbolen bevatten.',
	'PASSWORD'					=> 'Wachtwoord',
	'PASSWORD_ACTIVATED'		=> 'Je nieuwe wachtwoord is geactiveerd.',
	'PASSWORD_UPDATED'			=> 'Een nieuw wachtwoord is verstuurd naar je geregistreerde e-mailadres.',
	'PERMISSIONS_RESTORED'		=> 'Originele permissies zijn succesvol hersteld.',
	'PERMISSIONS_TRANSFERRED'	=> 'Permissies van <strong>%s</strong> succesvol overgebracht, je kan nu het forum bezoeken met deze gebruikerspermissies.<br />Let op dat beheerderspermissies niet zijn overgebracht. Je kan op ieder moment je permissies terugzetten.',
	'PM_DISABLED'				=> 'Privéberichten zijn uitgeschakeld op dit forum.',
	'PM_FROM'					=> 'Van',
	'PM_FROM_REMOVED_AUTHOR'	=> 'Dit bericht is verstuurd door een gebruiker die niet meer geregistreerd is.',
	'PM_ICON'					=> 'PB icoon',
	'PM_INBOX'					=> 'Postvak In',
	'PM_MARK_ALL_READ'			=> 'Markeer alle berichten als gelezen',
	'PM_MARK_ALL_READ_SUCCESS'	=> 'Alle privéberichten in deze map zijn gemarkeerd als gelezen',
	'PM_NO_USERS'				=> 'De gevraagde gebruiker om toe te voegen bestaat niet.',
	'PM_OUTBOX'					=> 'Postvak Uit',
	'PM_SENTBOX'				=> 'Verzonden berichten',
	'PM_SUBJECT'				=> 'Berichtenonderwerp',
	'PM_TO'						=> 'Verstuur naar',
	'PM_TOOLS'					=> 'Berichthulpmiddel',
	'PM_USERS_REMOVED_NO_PERMISSION'	=> 'Sommige gebruikers konden niet worden toegevoegd aangezien ze niet de permissies hebben om privéberichten te lezen.',
	'PM_USERS_REMOVED_NO_PM'	=> 'Sommige gebruikers kunnen niet toegevoegd worden, omdat ze het ontvangen van privéberichten hebben uitgeschakeld.',
	'POST_EDIT_PM'				=> 'Wijzig bericht',
	'POST_FORWARD_PM'			=> 'Doorsturen bericht',
	'POST_NEW_PM'				=> 'Bericht opstellen',
	'POST_PM_LOCKED'			=> 'Privébericht is gesloten.',
	'POST_PM_POST'				=> 'Citeer bericht',
	'POST_QUOTE_PM'				=> 'Citeer bericht',
	'POST_REPLY_PM'				=> 'Reageer op bericht',
	'PRINT_PM'					=> 'Afdrukweergave',
	'PREFERENCES_UPDATED'		=> 'Je voorkeuren zijn bijgewerkt.',
	'PROFILE_INFO_NOTICE'		=> 'Let op dat deze informatie zichtbaar is voor andere gebruikers. Wees voorzichtig met het bijvoegen van persoonlijke details. Elk veld gemarkeerd met een * moet ingevuld worden.',
	'PROFILE_UPDATED'			=> 'Je profiel is bijgewerkt.',
	'PROFILE_AUTOLOGIN_KEYS'	=> 'De "Onthoud mij"-aanmeldsleutels meld je automatisch aan wanneer je het forum bezoekt. Wanneer je je afmeld, zal de onthoud mij aanmeldsleutel alleen verwijderd worden van de computer die je gebruikt om af te melden. Hier kan je zien de onthoud mij aanmeldsleutels op andere computers die je gebruikt hebt om deze site te bezoeken.',
	'PROFILE_NO_AUTOLOGIN_KEYS'	=> 'Er zijn geen opgeslagen "Onthoud mij"-aanmeldsleutels.',

	'RECIPIENT'							=> 'Ontvanger',
	'RECIPIENTS'						=> 'Ontvangers',
	'REGISTRATION'						=> 'Registratie',
	'RELEASE_MESSAGES'					=> '%sMaak alle teruggehouden berichten vrij%s… ze zullen gesorteerd worden in de bijbehorende map als er genoeg ruimte beschikbaar is.',
	'REMOVE_ADDRESS'					=> 'Verwijder adres',
	'REMOVE_SELECTED_BOOKMARKS'			=> 'Verwijder geselecteerde favorieten',
	'REMOVE_SELECTED_BOOKMARKS_CONFIRM'	=> 'Weet je zeker dat je alle geselecteerde favorieten wilt verwijderen?',
	'REMOVE_BOOKMARK_MARKED'			=> 'Verwijder gemarkeerde favorieten',
	'REMOVE_FOLDER'						=> 'Verwijder map',
	'REMOVE_FOLDER_CONFIRM'				=> 'Weet je zeker dat je deze map wilt verwijderen?',
	'RENAME'							=> 'Hernoem',
	'RENAME_FOLDER'						=> 'Hernoem map',
	'REPLIED_MESSAGE'					=> 'Gereageerd op bericht',
	'REPLY_TO_ALL'						=> 'Reageer op verzender en alle ontvangers.',
	'REPORT_PM'							=> 'Meld privébericht',
	'RESIGN_SELECTED'					=> 'Zeg geselecteerde op',
	'RETURN_FOLDER'						=> '%1$sTerug naar vorige map%2$s',
	'RETURN_UCP'						=> '%sTerug naar gebruikerspaneel%s',
	'RULE_ADDED'						=> 'Regel succesvol toegevoegd.',
	'RULE_ALREADY_DEFINED'				=> 'Deze regel is de vorige keer al opgegeven.',
	'RULE_DELETED'						=> 'Regel succesvol verwijderd.',
	'RULE_LIMIT_REACHED'				=> 'Je kan niet meer PB regels toevoegen. Je hebt het maximum aantal regels bereikt.',
	'RULE_NOT_DEFINED'					=> 'Regel niet correct ingevoerd.',
	'RULE_REMOVED_MESSAGES'				=> array(
		1	=> '%d privébericht is verwijderd vanwege privéberichten filters.',
		2	=> '%d privéberichten zijn verwijderd vanwege privéberichten filters.',
	),

	'SAME_PASSWORD_ERROR'		=> 'Het nieuwe wachtwoord dat je hebt ingevoerd, is hetzelfde als je wachtwoord momenteel.',
	'SEARCH_YOUR_POSTS'			=> 'Je berichten weergeven',
	'SEND_PASSWORD'				=> 'Wachtwoord versturen',
	'SENT_AT'					=> 'Verstuurd op',			// Used before dates in private messages
	'SHOW_EMAIL'				=> 'Gebruikers kunnen contact met mij opnemen via e-mail',
	'SIGNATURE_EXPLAIN'			=> 'Dit is een blok tekst dat toegevoegd kan worden aan de berichten die je maakt. Er is een %d karakter limiet.',
	'SIGNATURE_PREVIEW'			=> 'Je onderschrift zal er zo uit zien in berichten',
	'SIGNATURE_TOO_LONG'		=> 'Je onderschrift is te lang.',
	'SELECT_CURRENT_TIME'		=> 'Selecteer tijd',
	'SELECT_TIMEZONE'			=> 'Selecteer tijdzone',
	'SORT'						=> 'Sorteer',
	'SORT_COMMENT'				=> 'Bestandscommentaar',
	'SORT_DOWNLOADS'			=> 'Downloads',
	'SORT_EXTENSION'			=> 'Extensie',
	'SORT_FILENAME'				=> 'Bestandsnaam',
	'SORT_POST_TIME'			=> 'Berichtentijd',
	'SORT_SIZE'					=> 'Bestandsgrootte',

	'TIMEZONE'					=> 'Tijdzone',
	'TIMEZONE_DATE_SUGGESTION'	=> 'Suggestie: %s',
	'TIMEZONE_INVALID'			=> 'De tijdzone die je hebt geselecteerd is ongeldig.',
	'TO'						=> 'Ontvanger',
	'TO_MASS'					=> 'Ontvangers',
	'TO_ADD'					=> 'Ontvanger toevoegen',
	'TO_ADD_MASS'				=> 'Ontvangers toevoegen',
	'TO_ADD_GROUPS'				=> 'Groepen toevoegen',

	'TOO_MANY_RECIPIENTS'		=> 'Je hebt geprobeerd om een privébericht naar te veel ontvangers te versturen.',
	'TOO_MANY_REGISTERS'		=> 'Je hebt het maximum aantal registratie pogingen voor deze sessie overschreden. Probeer het later nog een keer.',

	'UCP'						=> 'Gebruikerspaneel',
	'UCP_ACTIVATE'				=> 'Activeer account',
	'UCP_ADMIN_ACTIVATE'		=> 'Let op dat je een geldig e-mailadres moet invullen voordat je account is geactiveerd. De beheerder zal je account beoordelen en als het goedgekeurd is, zal je een e-mail ontvangen op het adres dat je hebt gespecificeerd.',
	'UCP_ATTACHMENTS'			=> 'Bijlagen',
	'UCP_AUTH_LINK'				=> 'Externe accounts',
	'UCP_AUTH_LINK_ASK'			=> 'Je hebt momenteel geen account geassocieerd met deze externe service. Klik op de knop hieronder om je forumaccount te koppelen met een account van deze externe service.',
	'UCP_AUTH_LINK_ID'			=> 'Unieke identificatie',
	'UCP_AUTH_LINK_LINK'		=> 'Koppel',
	'UCP_AUTH_LINK_MANAGE'		=> 'Beheer externe account associaties', // wat is dit? geen idee
	'UCP_AUTH_LINK_NOT_SUPPORTED'	=> 'Het koppelen van forumaccounts met externe services wordt niet ondersteund door de ingestelde forum-authenticatie methode.',
	'UCP_AUTH_LINK_TITLE'		=> 'Beheer je externe account associaties',
	'UCP_AUTH_LINK_UNLINK'		=> 'Ontkoppel',
	'UCP_COPPA_BEFORE'			=> 'Voor %s',
	'UCP_COPPA_ON_AFTER'		=> 'Op of na %s',
	'UCP_EMAIL_ACTIVATE'		=> 'Let op dat je een geldig e-mailadres in moet vullen voordat je account wordt geactiveerd. Je zal een e-mail ontvangen op het adres dat je hebt opgegeven welke een account activatie koppeling bevat.',
	'UCP_JABBER'				=> 'Jabber-adres',
	'UCP_LOGIN_LINK'			=> 'Een externe account associatie opzetten',

	'UCP_MAIN'					=> 'Overzicht',
	'UCP_MAIN_ATTACHMENTS'		=> 'Beheer bijlagen',
	'UCP_MAIN_BOOKMARKS'		=> 'Beheer favorieten',
	'UCP_MAIN_DRAFTS'			=> 'Beheer concepten',
	'UCP_MAIN_FRONT'			=> 'Voorpagina',
	'UCP_MAIN_SUBSCRIBED'		=> 'Beheer abonnementen',

	'UCP_NO_ATTACHMENTS'		=> 'Je hebt geen bestanden geplaatst.',

	'UCP_NOTIFICATION_LIST'				=> 'Beheer notificaties',
	'UCP_NOTIFICATION_LIST_EXPLAIN'		=> 'Hier kan je alle vorige notificaties bekijken.',
	'UCP_NOTIFICATION_OPTIONS'			=> 'Wijzig notificatie opties',
	'UCP_NOTIFICATION_OPTIONS_EXPLAIN'	=> 'Hier kan je je voorkeur notificatie methodes voor het forum instellen.',

	'UCP_PREFS'					=> 'Forumvoorkeuren',
	'UCP_PREFS_PERSONAL'		=> 'Wijzig algemene instellingen',
	'UCP_PREFS_POST'			=> 'Wijzig plaatsingsstandaarden',
	'UCP_PREFS_VIEW'			=> 'Wijzig weergave opties',

	'UCP_PM'					=> 'Privéberichten',
	'UCP_PM_COMPOSE'			=> 'Bericht opstellen',
	'UCP_PM_DRAFTS'				=> 'Beheer PB concepten',
	'UCP_PM_OPTIONS'			=> 'Regels, mappen en instellingen',
	'UCP_PM_UNREAD'				=> 'Ongelezen berichten',
	'UCP_PM_VIEW'				=> 'Bekijk berichten',

	'UCP_PROFILE'				=> 'Profiel',
	'UCP_PROFILE_AVATAR'		=> 'Wijzig avatar',
	'UCP_PROFILE_PROFILE_INFO'	=> 'Wijzig profiel',
	'UCP_PROFILE_REG_DETAILS'	=> 'Wijzig account instellingen',
	'UCP_PROFILE_SIGNATURE'		=> 'Wijzig onderschrift',
	'UCP_PROFILE_AUTOLOGIN_KEYS'=> 'Beheer “Onthoud mij”-aanmeldsleutels',

	'UCP_USERGROUPS'			=> 'Gebruikersgroepen',
	'UCP_USERGROUPS_MEMBER'		=> 'Wijzig lidmaatschappen',
	'UCP_USERGROUPS_MANAGE'		=> 'Beheer groepen',

	'UCP_PASSWORD_RESET_DISABLED'	=> 'Het “wachtwoord herstel”-functionaliteit is uitgeschakeld. Als je hulp nodig hebt om toegang te krijgen tot je account, neem dan contact op met de %sForumbeheerder%s',
	'UCP_REGISTER_DISABLE'			=> 'Het aanmaken van een nieuw account is momenteel niet mogelijk.',
	'UCP_REMIND'					=> 'Verstuur wachtwoord',
	'UCP_RESEND'					=> 'Verstuur activatie e-mail',
	'UCP_WELCOME'					=> 'Welkom in het gebruikerspaneel. Hier kan je je profiel, voorkeuren, geabonneerde fora en onderwerpen controleren, bekijken en bijwerken. Je kan ook berichten naar andere gebruikers versturen (indien toegestaan). Zorg er voor dat je iedere aankondiging leest voordat je doorgaat.',
	'UCP_ZEBRA'						=> 'Vrienden en Vijanden',
	'UCP_ZEBRA_FOES'				=> 'Beheer vijanden',
	'UCP_ZEBRA_FRIENDS'				=> 'Beheer vrienden',
	'UNDISCLOSED_RECIPIENT'			=> 'Onbekende ontvanger',
	'UNKNOWN_FOLDER'				=> 'Onbekende map',
	'UNWATCH_MARKED'				=> 'Gemarkeerde niet meer volgen',
	'UPLOAD_AVATAR_FILE'			=> 'Upload van je computer',
	'UPLOAD_AVATAR_URL'				=> 'Upload van een URL',
	'UPLOAD_AVATAR_URL_EXPLAIN'		=> 'Voer de URL van de locatie die de afbeelding bevat . De afbeelding zal gekopieerd worden naar deze site.',
	'USERNAME_ALPHA_ONLY_EXPLAIN'	=> 'Gebruikersnaam moet tussen de %1$s en %2$s tekens lang zijn en alleen uit alfanumerieke karakters bestaan.',
	'USERNAME_ALPHA_SPACERS_EXPLAIN'=> 'Gebruikersnaam moet tussen de %1$s en %2$s tekens lang zijn en alleen uit alfanumerieke, spatie of -+_[] tekens bestaan.',
	'USERNAME_ASCII_EXPLAIN'		=> 'Gebruikersnaam moet tussen de %1$s en %2$s tekens lang zijn en alleen uit ASCII karakters bestaan, dus geen speciale symbolen.',
	'USERNAME_LETTER_NUM_EXPLAIN'	=> 'Gebruikersnaam moet tussen de %1$s en %2$s tekens lang zijn en alleen letters en cijfers bestaan.',
	'USERNAME_LETTER_NUM_SPACERS_EXPLAIN'=> 'Gebruikersnaam moet tussen de %1$s en %2$s karakters lang zijn en alleen uit letters, cijfers, spatie of -+_[] tekens bestaan.',
	'USERNAME_CHARS_ANY_EXPLAIN'	=> 'Lengte moet tussen de %1$s en %2$s karakters lang zijn.',
	'USERNAME_TAKEN_USERNAME'		=> 'De gebruikersnaam die je hebt ingevoerd is al in gebruik, kies een andere naam.',
	'USERNAME_DISALLOWED_USERNAME'	=> 'De gebruikersnaam die je hebt ingevoerd is niet toegestaan of bevat een ongeldig woord. Kies een andere naam.',
	'USER_NOT_FOUND_OR_INACTIVE'	=> 'De gebruikersnaam die je hebt ingevoerd kan niet gevonden worden of is geen actieve gebruiker.',

	'VIEW_AVATARS'				=> 'Weergave avatars',
	'VIEW_EDIT'					=> 'Bekijk/Wijzig',
	'VIEW_FLASH'				=> 'Weergave Flash animaties',
	'VIEW_IMAGES'				=> 'Weergave afbeeldingen in berichten',
	'VIEW_NEXT_HISTORY'			=> 'Volgende PB in geschiedenis',
	'VIEW_NEXT_PM'				=> 'Volgende PB',
	'VIEW_PM'					=> 'Bekijk bericht',
	'VIEW_PM_INFO'				=> 'Berichtdetails',
	'VIEW_PM_MESSAGES'			=> array(
		1	=> '%d bericht',
		2	=> '%d berichten',
	),
	'VIEW_PREVIOUS_HISTORY'		=> 'Vorige PB in geschiedenis',
	'VIEW_PREVIOUS_PM'			=> 'Vorige PB',
	'VIEW_PROFILE'				=> 'Bekijk profiel',
	'VIEW_SIGS'					=> 'Onderschriften weergeven',
	'VIEW_SMILIES'				=> 'Smilies weergeven als afbeeldingen',
	'VIEW_TOPICS_DAYS'			=> 'Onderwerpen van vorige dagen weergeven',
	'VIEW_TOPICS_DIR'			=> 'Onderwerp sorteer volgorde weergeven',
	'VIEW_TOPICS_KEY'			=> 'Onderwerpen sorteren op weergeven',
	'VIEW_POSTS_DAYS'			=> 'Berichten van vorige dagen weergeven',
	'VIEW_POSTS_DIR'			=> 'Bericht sorteer volgorde weergeven',
	'VIEW_POSTS_KEY'			=> 'Berichten sorteren op weergeven',

	'WATCHED_EXPLAIN'			=> 'Hieronder is een lijst van forums en onderwerpen waarop je bent geabonneerd. Je zal op de hoogte gebracht worden van nieuwe berichten in beide. Om je abonnement op te heffen markeer het forum of onderwerp en druk op de <em>Gemarkeerde opzeggen</em> knop.',
	'WATCHED_FORUMS'			=> 'Geabonneerde forums',
	'WATCHED_TOPICS'			=> 'Geabonneerde onderwerpen',
	'WRONG_ACTIVATION'			=> 'De activatiesleutel die je hebt opgegeven komt niet overeen met degene in de database.',

	'YOUR_DETAILS'				=> 'Je activiteit',
	'YOUR_FOES'					=> 'Je vijanden',
	'YOUR_FOES_EXPLAIN'			=> 'Om gebruikersnamen te verwijderen, selecteer ze en druk op verstuur.',
	'YOUR_FRIENDS'				=> 'Je vrienden',
	'YOUR_FRIENDS_EXPLAIN'		=> 'Om gebruikersnamen te verwijderen, selecteer ze en druk op verstuur.',
	'YOUR_WARNINGS'				=> 'Je waarschuwingsniveau',

	'PM_ACTION' => array(
		'PLACE_INTO_FOLDER'	=> 'Plaats in map',
		'MARK_AS_READ'		=> 'Markeer als gelezen',
		'MARK_AS_IMPORTANT'	=> 'Markeer bericht',
		'DELETE_MESSAGE'	=> 'Verwijder bericht',
	),
	'PM_CHECK' => array(
		'SUBJECT'	=> 'Onderwerp',
		'SENDER'	=> 'Afzender',
		'MESSAGE'	=> 'Bericht',
		'STATUS'	=> 'Berichtenstatus',
		'TO'		=> 'Verstuurd naar',
	),
	'PM_RULE' => array(
		'IS_LIKE'		=> 'is als',
		'IS_NOT_LIKE'	=> 'is niet als',
		'IS'			=> 'is',
		'IS_NOT'		=> 'is niet',
		'BEGINS_WITH'	=> 'begint met',
		'ENDS_WITH'		=> 'eindigt met',
		'IS_FRIEND'		=> 'is vriend',
		'IS_FOE'		=> 'is vijand',
		'IS_USER'		=> 'is gebruiker',
		'IS_GROUP'		=> 'is in gebruikersgroep',
		'ANSWERED'		=> 'beantwoord',
		'FORWARDED'		=> 'doorgestuurd',
		'TO_GROUP'		=> 'naar mijn standaard gebruikersgroep',
		'TO_ME'			=> 'naar mij',
	),

	'GROUPS_EXPLAIN'	=> 'Gebruikersgroepen staan forumbeheerders in staat om gebruikers beter te beheren. Standaard zal je geplaatst worden in een specifieke groep, dit is je standaard groep. Deze groep definieert hoe je mag voorkomen naar andere gebruikers, bijvoorbeeld de kleur van je gebruikersnaam, avatar, rang, etc. Afhankelijk van de beheerder, kan je je standaard groep veranderen. Je kan ook geplaatst worden of toegestaan om toe te treden tot andere gebruikersgroepen. Sommige groepen kunnen je extra permissies geven om inhoud te kunnen zien of om je mogelijkheden op andere gebieden uit te breiden.',
	'GROUP_LEADER'		=> 'Leiderschappen',
	'GROUP_MEMBER'		=> 'Lidmaatschappen',
	'GROUP_PENDING'		=> 'Wachtende lidmaatschappen',
	'GROUP_NONMEMBER'	=> 'Geen lidmaatschap',
	'GROUP_DETAILS'		=> 'Groepsdetails',

	'NO_LEADER'		=> 'Geen groepleiderschappen',
	'NO_MEMBER'		=> 'Geen groeplidmaatschappen',
	'NO_PENDING'	=> 'Geen wachtende lidmaatschappen',
	'NO_NONMEMBER'	=> 'Geen non-lid groepen',
));
